# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import timedelta

from django.conf import settings
from rest_framework import serializers

from travel.rasp.library.python.common23.date import environment
from common.utils.date import MSK_TZ, parse_date as utils_parse_date


def dump_datetime(local_dt):
    return {'value': local_dt.isoformat(), 'timezone': local_dt.tzinfo.zone}


def get_tomorrow_date(local_tz=None):
    if local_tz is None:
        local_tz = MSK_TZ
    return (environment.now_utc(aware=True) + timedelta(days=1)).astimezone(local_tz).date()


def parse_date(value, local_tz, today_default=False, ignore_past=True):
    today = environment.now_aware().astimezone(local_tz).date()
    default = today if today_default else None

    if not value:
        return default

    try:
        parsed_date = utils_parse_date(value)
    except (TypeError, ValueError):
        raise serializers.ValidationError('invalid date value: it should be in YYYY-MM-DD format')

    offset = parsed_date - today
    past_date = offset < timedelta(0)
    if past_date:
        if ignore_past:
            return default
        raise serializers.ValidationError(
            'invalid date value: it should be present date'
        )

    date_limit = timedelta(days=365 - settings.DAYS_TO_PAST)
    if offset > date_limit:
        raise serializers.ValidationError(
            'invalid date value: it should be within {} days in future'.format(date_limit.days)
        )

    return parsed_date
