# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple

from rest_framework import serializers

from travel.rasp.wizards.wizard_lib.direction.sorting import DEFAULT_SORTING, SORTINGS
from travel.rasp.wizards.wizard_lib.serialization.point import dump_point


def parse_sorting(value):
    if not value:
        return DEFAULT_SORTING

    try:
        return SORTINGS[value]
    except KeyError:
        raise serializers.ValidationError('invalid order_by value: it should be one of {}'.format(sorted(SORTINGS)))


DirectionQuery = namedtuple('DirectionQuery', ('departure_point', 'arrival_point',
                                               'original_departure_point', 'original_arrival_point',
                                               'departure_date',
                                               'language', 'experiment_flags', 'sorting', 'filters',
                                               'tld', 'limit', 'main_reqid'))


def dump_query(query, is_filters_needed=True):
    dumped = {
        'query': {
            'departure_point': dump_point(query.departure_point),
            'arrival_point': dump_point(query.arrival_point),
            'original_departure_point':
                dump_point(query.original_departure_point)
                if query.original_departure_point is not None
                else None,
            'original_arrival_point':
                dump_point(query.original_arrival_point)
                if query.original_arrival_point is not None
                else None,
            'departure_date': query.departure_date and query.departure_date.strftime('%Y-%m-%d'),
            'language': query.language,
            'order_by': query.sorting.value
        },
    }
    if is_filters_needed:
        dumped.update({'filters': query.filters.dump()})
    return dumped
