# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.rasp.wizards.wizard_lib.experiment_flags import ExperimentFlag


def _iparse_experiment_flags(value):
    if not value:
        return
    for flag_value in value.split(','):
        try:
            yield ExperimentFlag(flag_value)
        except ValueError:
            continue


def parse_experiment_flags(value):
    return frozenset(_iparse_experiment_flags(value))
