# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from enum import Enum
from rest_framework import serializers


class IntentType(Enum):
    BUY = 'purchase'


def parse_intent(value):
    if not value:
        return None

    try:
        return IntentType(value)
    except ValueError:
        raise serializers.ValidationError(
            'invalid intent type: {!r}'.format(value)
        )
