# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings
from rest_framework import serializers


def parse_language(value):
    if not value:
        return settings.LANGUAGE_CODE

    if value not in settings.FRONTEND_LANGUAGES:
        raise serializers.ValidationError('invalid language value: it should be one of {}'
                                          .format(settings.FRONTEND_LANGUAGES))

    return value
