# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from rest_framework import serializers

DEFAULT_SEGMENTS_LIMIT = 10


def parse_limit(value, experiment_flags):
    if value is None:
        return DEFAULT_SEGMENTS_LIMIT

    try:
        limit = int(value)
    except (TypeError, ValueError):
        raise serializers.ValidationError('invalid limit value: it should be number')

    return limit
