# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.rasp.wizards.wizard_lib.serialization.date import dump_datetime
from travel.rasp.wizards.wizard_lib.serialization.price import dump_price, dump_full_price


PRICE_ROUNDING_LIMIT = 100  # minumum price amount with unsignificant subunits that should be rounded


def dump_place(places_group, dump_function=dump_price):
    return {
        'coach_type': places_group.coach_type,
        'count': places_group.count,
        'max_seats_in_the_same_car': places_group.max_seats_in_the_same_car,
        'price': dump_function(places_group.price),
        'price_details': places_group.price_details,
        'service_class': places_group.service_class,
    }


def dump_tarif_info_places(tariff_info):
    return [
        dump_place(places_group, dump_full_price) for places_group in tariff_info.places
    ] if tariff_info.places is not None else None


def dump_places(segment):
    electronic_ticket = (
        {}
        if segment.places is None or all(place.count == 0 for place in segment.places)
        else {'electronic_ticket': segment.electronic_ticket}
    )
    return dict(
        records=[
            dump_place(places_group)
            for places_group in segment.places
        ] if segment.places is not None else None,
        updated_at=dump_datetime(segment.updated_at) if segment.updated_at is not None else None,
        **electronic_ticket
    )
