# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

PRICE_ROUNDING_LIMIT = 100  # minumum price amount with unsignificant subunits that should be rounded


def dump_full_price(price):
    return dict(
        price.__dict__,
        **{'sort_value': price.sort_value}
    )


def dump_price(price):
    if price is None:
        return None

    value = price.value
    if value > PRICE_ROUNDING_LIMIT:
        value = round(value)

    return {'value': value, 'currency': price.currency}
