# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from enum import Enum
from rest_framework import serializers

from common.models_abstract.schedule import ExpressType


class ThreadExpressType(Enum):
    AEROEXPRESS = ExpressType.AEROEXPRESS
    EXPRESS = ExpressType.EXPRESS


def parse_thread_express_type(value):
    if not value:
        return None

    try:
        return ThreadExpressType(value)
    except ValueError:
        raise serializers.ValidationError(
            'invalid thread express type: {!r}'.format(value)
        )
