# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.settings.configuration import BaseConfigurator


class TouchHostConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['TOUCH_HOST_BY_TLD'] = {
            'ru': 't.rasp.yandex.ru',
            'by': 't.rasp.yandex.by',
            'ua': 't.rasp.yandex.ua',
            'kz': 't.rasp.yandex.kz',
            'uz': 't.rasp.yandex.uz',
        }

    def apply_testing(self, settings):
        settings['TOUCH_HOST_BY_TLD'] = {
            'ru': 't.testing.morda-front.rasp.common.yandex.ru',
            'by': 't.testing.morda-front.rasp.common.yandex.by',
            'ua': 't.testing.morda-front.rasp.common.yandex.ua',
            'kz': 't.testing.morda-front.rasp.common.yandex.kz',
            'uz': 't.testing.morda-front.rasp.common.yandex.uz',
        }


class MordaHostConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['MORDA_HOST_BY_TLD'] = {
            'ru': 'rasp.yandex.ru',
            'by': 'rasp.yandex.by',
            'ua': 'rasp.yandex.ua',
            'kz': 'rasp.yandex.kz',
            'uz': 'rasp.yandex.uz',
        }

    def apply_testing(self, settings):
        settings['MORDA_HOST_BY_TLD'] = {
            'ru': 'testing.morda-front.rasp.common.yandex.ru',
            'ua': 'testing.morda-front.rasp.common.yandex.ua',
            'kz': 'testing.morda-front.rasp.common.yandex.kz',
            'by': 'testing.morda-front.rasp.common.yandex.by',
            'uz': 'testing.morda-front.rasp.common.yandex.uz',
        }


class TrainsHostConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['TRAINS_HOST_BY_TLD'] = {
            'ru': 'trains.yandex.ru',
            'ua': 'trains.yandex.ua',
            'kz': 'trains.yandex.kz',
            'by': 'trains.yandex.by',
            'uz': 'trains.yandex.uz',
        }

    def apply_testing(self, settings):
        settings['TRAINS_HOST_BY_TLD'] = {
            'ru': 'testing.trains.common.yandex.ru',
            'ua': 'testing.trains.common.yandex.ua',
            'kz': 'testing.trains.common.yandex.kz',
            'by': 'testing.trains.common.yandex.by',
            'uz': 'testing.trains.common.yandex.uz',
        }


class TravelHostConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        settings['TRAVEL_HOST_BY_TLD'] = {
            'ru': 'travel.yandex.ru',
            'ua': 'travel.yandex.ru',
            'kz': 'travel.yandex.ru',
            'by': 'travel.yandex.ru',
            'uz': 'travel.yandex.ru',
        }

    def apply_testing(self, settings):
        settings['TRAVEL_HOST_BY_TLD'] = {
            'ru': 'travel-test.yandex.ru',
            'ua': 'travel-test.yandex.ru',
            'kz': 'travel-test.yandex.ru',
            'by': 'travel-test.yandex.ru',
            'uz': 'travel-test.yandex.ru',
        }
