# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from os.path import dirname, join, realpath

from common.settings.configuration import BaseConfigurator


class LocaleConfigurator(BaseConfigurator):
    def apply_base(self, settings):
        locale_path = join(dirname(realpath(dirname(__file__))), 'locale')
        settings.setdefault('LOCALE_PATHS', []).append(locale_path)
        settings['TANKER_KEYSETS']['wizardia'] = (locale_path, ('ru', 'uk',))
