# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from functools import wraps


def compose(*funcs):
    def composed(value):
        return reduce(lambda value, func: func(value), funcs, value)
    return composed


def tuplify(gen_factory):
    @wraps(gen_factory)
    def wrapped(*args, **kwargs):
        return tuple(gen_factory(*args, **kwargs))
    return wrapped
