# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from common.models.geo import Settlement, Station
from common.models.transport import TransportType
from geosearch.models import NameSearchIndex
from route_search.models import ZNodeRoute2


def _fetch_suburban_models_ids():
    settlement_ids = set()
    station_ids = set()

    for (
        departure_station_id, arrival_station_id, departure_settlement_id, arrival_settlement_id
    ) in ZNodeRoute2.objects.filter(
        t_type=TransportType.SUBURBAN_ID
    ).values_list(
        'station_from_id', 'station_to_id', 'settlement_from_id', 'settlement_to_id'
    ):
        settlement_ids.update((departure_settlement_id, arrival_settlement_id))
        station_ids.update((departure_station_id, arrival_station_id))

    settlement_ids.discard(None)  # settlement_from_id and settlement_to_id is nullable fields

    return {Settlement: settlement_ids, Station: station_ids}


class PrecacheManager(object):
    @staticmethod
    def using_precache():
        models_ids = _fetch_suburban_models_ids()
        return NameSearchIndex.using_partial_precache(models_ids)
