import os
from os.path import dirname

from library.python import resource


def extract_resources(base_path, prefix):
    """Создаем файлы из ресурсов ya.make для корректной работы миграций и шаблонов"""
    for path, data in resource.iteritems(prefix=prefix, strip_prefix=True):
        filepath = os.path.join(base_path, path)
        if not os.path.exists(filepath):
            parent = dirname(filepath)
            if not os.path.exists(parent):
                os.makedirs(parent)
            with open(filepath, 'wb') as f:
                f.write(data)
