# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from HTMLParser import HTMLParser

from travel.rasp.wizards.wizard_lib.utils.jinja2 import render_macros


def wrap_for_highlight(text):
    return {'__hl': text}


def unescape_html(html):
    return HTMLParser().unescape(html)


def render_texts(template_name, context, experiments):
    block_texts = render_macros(
        template_name=template_name,
        context=context,
        macro_names=('title', 'snippet',),
        experiments=experiments,
    )

    return {
        block_name: wrap_for_highlight(unescape_html(block_text)) for block_name, block_text in block_texts.iteritems()
    }
