# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from functools import wraps
from logging import getLogger

from rest_framework import serializers

log = getLogger(__name__)


def log_validation_error(func):
    @wraps(func)
    def decorated(request, *args, **kwargs):
        try:
            return func(request, *args, **kwargs)
        except serializers.ValidationError as e:
            log.error("Catch ValidationError: URL [%s] ERROR: [%s]", request.get_full_path(), e)
            raise

    decorated.__name__ = func.__name__
    return decorated
