# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import urlparse

from django.conf import settings


def _get_host(host_by_tld, tld):
    tld = tld if tld in host_by_tld else 'ru'
    return host_by_tld[tld]


def get_morda_host(tld):
    return _get_host(settings.MORDA_HOST_BY_TLD, tld)


def get_touch_host(tld):
    return _get_host(settings.TOUCH_HOST_BY_TLD, tld)


def get_trains_host(tld):
    return _get_host(settings.TRAINS_HOST_BY_TLD, tld)


def _format_url(host, path, query):
    return urlparse.SplitResult(scheme='https', netloc=host, path=path, query=query, fragment=None).geturl()


def format_morda_url(path, query, tld):
    host = get_morda_host(tld)
    return _format_url(host, path, query)


def format_touch_url(path, query, tld):
    host = get_touch_host(tld)
    return _format_url(host, path, query)


def format_trains_url(path, query, tld):
    host = get_trains_host(tld)
    return _format_url(host, path, query)
