PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/drf-ujson

    library/python/resource

    travel/library/python/tracing/instrumentation

    travel/rasp/library/python/common
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/route_search
    travel/rasp/wizards/wizard_lib/protobuf_models
)

PY_SRCS(
    __init__.py
    cache.py
    direction/__init__.py
    direction/filters.py
    direction/logger.py
    direction/segments.py
    direction/sorting.py
    event_date_query.py
    experiment_flags.py
    geobase_region_type.py
    optimal_direction_provider.py
    region_capital_provider.py
    serialization/__init__.py
    serialization/date.py
    serialization/direction.py
    serialization/experiment_flags.py
    serialization/intent_type.py
    serialization/language.py
    serialization/legacy_direction.py
    serialization/limit.py
    serialization/point.py
    serialization/place.py
    serialization/price.py
    serialization/proto_direction.py
    serialization/segments.py
    serialization/thread_express_type.py
    settings/__init__.py
    settings/hosts.py
    settings/locale.py
    station/__init__.py
    station/direction_type.py
    tests_utils.py
    tests/helpers/__init__.py
    tests/helpers/fake_url_conf.py
    utils/__init__.py
    utils/functional.py
    utils/jinja2.py
    utils/json_renderer.py
    utils/namesearchindex_precache_suburban.py
    utils/originalbox.py
    utils/resource_extractor.py
    utils/shrinked_timezones.py
    utils/text.py
    utils/timestamp_checker.py
    utils/yasm_metric_manager.py
    views/helpers/__init__.py
    views/helpers/error_handlers.py
    views/helpers/service_urls.py
    views/__init__.py
    views/ping.py
    views/version.py
)

RESOURCE_FILES(
    PREFIX travel/rasp/wizards/wizard_lib
    locale/django.pot
    locale/ru/LC_MESSAGES/django.po
    locale/ru/LC_MESSAGES/django.mo
    locale/uk/LC_MESSAGES/django.po
    locale/uk/LC_MESSAGES/django.mo
)

END()

RECURSE_FOR_TESTS(
    tests
)
