#!/usr/bin/env python

import os
import subprocess
import sys

SERVICE_NAME = "db-migrator"

def get_base_dir():
    return os.path.join(os.path.dirname(os.path.abspath(__file__)), "..")


def get_classpath():
    return os.path.join(get_base_dir(), SERVICE_NAME, "*")

def get_jars_dir():
    return os.path.join(get_base_dir(), SERVICE_NAME)

def get_migration_dirs():
    return ",".join([ "filesystem:{}".format(os.path.join(get_base_dir(), "..", migration_path)) for migration_path in ["migrations/common", "migrations/postgresql"] ])

def get_config_file():
    return os.path.join(get_base_dir(), "..", "conf/flyway.conf")

def get_java_args():
    return [
        # ipv6
        "-Djava.net.preferIPv6Addresses=true",
        "-Djava.net.preferIPv4Stack=false",

        # i/o
        "-Dfile.encoding=UTF-8"
    ]


def get_java_binary():
    return os.path.join(get_base_dir(), "jdk/bin/java")


def get_env_value_or_default(env_var_name, default):
    val = os.environ.get(env_var_name)
    if val is None:
        val = default
    return val


if __name__ == "__main__":
    call_args = [get_java_binary()]
    call_args.extend(get_java_args())
    call_args.append("-classpath")
    call_args.append(get_classpath())
    call_args.append("org.flywaydb.commandline.Main")
    call_args.append("-configFiles={}".format(get_config_file()))
    call_args.append("-jarDirs={}".format(get_jars_dir()))
    call_args.append("-locations={}".format(get_migration_dirs()))
    call_args.extend(sys.argv[1:])
    sys.exit(subprocess.call(call_args))
