# coding: utf8
from datetime import datetime, timedelta
from enum import Enum

START_TRACKING_DATETIME = (datetime.utcnow() - timedelta(31*6)).strftime('%Y-%m-%d')


class Teams(Enum):
    AVIA = 'Avia'
    KOMOD = 'Komod'
    OTT = 'Organic'
    HOTELS = 'Hotels'
    TRAIN_O_BUSES = 'TrainOBuses'


FILTERS_BY_TEAM = {
    Teams.AVIA.value: 'Queue: Авиабилеты AND resolution: fixed And Resolved: >= {}'.format(START_TRACKING_DATETIME),
    Teams.KOMOD.value: 'Boards: "[Travel] КОМОД" AND Resolution: Решен AND Type: !Дизайн And Resolved: >= {}'.format(START_TRACKING_DATETIME),
    Teams.OTT.value: 'Boards: "travel organic sprints" AND Tags: !infra AND Resolution: Решен And Resolved: >= {}'.format(START_TRACKING_DATETIME),
    Teams.HOTELS.value: 'Boards: Отели AND Resolution: Решен And key: "HOTELS-5414" And Assignee: !"Николай Степовой" And Queue: HOTELS And Resolved: >= {}'.format(START_TRACKING_DATETIME),
    Teams.TRAIN_O_BUSES.value: 'Boards: "[Travel]Поездобусы" AND Resolution: РешенAnd Resolved: >= {}'.format(START_TRACKING_DATETIME),
}
