# coding: utf8
from infi.clickhouse_orm import Model, ArrayField, StringField, DateTimeField, UInt8Field, Int32Field, Float32Field, MergeTree, Log
from loguru import logger


ISSUES_PK = ('team', 'queue', 'key')


class _BaseRepository:
    MODEL = None

    def __init__(self, db):
        self._db = db

    def create_table(self):
        self._db.create_table(self.MODEL)

    def recreate_table(self):
        try:
            self._db.drop_table(self.MODEL)
        except Exception:
            logger.exception('Error while dropping table')
        self.create_table()

    def save_one(self, obj) -> None:
        self._db.insert([obj])

    def save_many(self, objs) -> None:
        self._db.insert(objs)


class Issue(Model):
    team = StringField()
    queue = StringField()

    key = StringField()
    url = StringField()

    last_sprint = StringField()
    sprints = ArrayField(StringField())
    tags = ArrayField(StringField())
    sp = Float32Field()
    ttm = Int32Field()

    closed_at = DateTimeField()

    duplicate = UInt8Field()

    is_feature = UInt8Field(default=0)

    engine = MergeTree('closed_at', ISSUES_PK, primary_key=ISSUES_PK)


class IssuesRepository(_BaseRepository):
    MODEL = Issue


AGGREGATE_PK = ('ts', 'team', 'queue', 'is_feature', 'sp')


class Aggregate(Model):
    team = StringField()
    queue = StringField()
    is_feature = UInt8Field(default=0)
    ts = DateTimeField()
    sp = Float32Field()

    median = Int32Field()
    std3 = Float32Field()
    perc95 = Float32Field()
    perc90 = Float32Field()
    perc75 = Float32Field()

    engine = MergeTree('ts', AGGREGATE_PK, primary_key=AGGREGATE_PK)


class AggregateRepository(_BaseRepository):
    MODEL = Aggregate


class RetortaLinks(Model):
    team = StringField()
    url = StringField()

    engine = Log()


class RetortaLinksRepository(_BaseRepository):
    MODEL = RetortaLinks
