# coding: utf8
from travel.tools.devprocess_metrics.startrek.model import RetortaLinks
from travel.tools.devprocess_metrics.startrek.conf import FILTERS_BY_TEAM

RETORTA_URL_TEMPLATE = 'https://retorta.in.yandex-team.ru/?query={query}&finalStatuses=2%2C3&zoom=0'


def save_retorta_links(repository):
    for team, filter_ in FILTERS_BY_TEAM.items():
        repository.save_one(RetortaLinks(
            team=team,
            url=_build_url(filter_)
        ))


def _build_url(filter_):
    return RETORTA_URL_TEMPLATE.format(
        query=filter_ + ' AND tags: feature'
    )
