# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import argparse

from loguru import logger
from startrek_client import Startrek

from travel.library.python.rasp_vault.api import get_secret

from travel.tools.release_tracker.collector.startrek import StartrekRMCollector
from travel.tools.release_tracker.model import ReleaseRepository


def run(recreate=False):
    release_repository = ReleaseRepository(
        host='https://sas-cksd4pfhlk3ecj5f.db.yandex.net:8443',
        user=get_secret('rasp-misc.rasp_devmetrics_ch_user'),
        password=get_secret('rasp-misc.rasp_devmetrics_ch_password'),
        db='devmetrics'
    )
    release_repository.connect()
    if recreate:
        try:
            release_repository.recreate_table()
        except Exception:
            logger.exception('Error while recreating table')

    st_client = Startrek(useragent='v2', token=get_secret('rasp-robot-tokens-and-passwords.startrek-oauth-token'))

    st_collector = StartrekRMCollector(
        st_client,
        'Queue: RASPFRONT AND Tags: rm_main_ticket  "Sort by": Updated DESC'
    )
    for release in st_collector.collect():
        logger.info('Issue: %s' % release)
        release_repository.save_one(release)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--recreate', help='Whether or not we should recreate table', action="store_true")

    args = parser.parse_args()
    run(args.recreate)
