from enum import Enum
from typing import Generator

from infi.clickhouse_orm import Model, StringField, DateField, Int32Field, Database, MergeTree


class EnvType(Enum):
    TESTING = 'testing'
    PRESTABLE = 'prestable'
    PRODUCTION = 'production'


RELEASES_PK = ('environment', 'project', 'created_ts')


class Release(Model):
    created_at = DateField()
    created_ts = Int32Field()
    created_at_str = StringField()
    project = StringField()
    environment = StringField()

    engine = MergeTree('created_at', RELEASES_PK, primary_key=RELEASES_PK)


class ReleaseRepository:

    def __init__(self, db, host, user, password):
        self._db_name = db
        self._host = host
        self._user = user
        self._password = password
        self._db = None

    def connect(self):
        self._db = Database(self._db_name, self._host, self._user, self._password)

    def create_table(self):
        self._db.create_table(Release)

    def recreate_table(self):
        self._db.drop_table(Release)
        self.create_table()

    def save_one(self, release: Release) -> None:
        self._db.insert([release])

    def save_many(self, releases: Generator[Release, None, None]) -> None:
        self._db.insert(releases)


def resolve_host():
    # TODO: switch on more smart service discovery
    return 'sas-cksd4pfhlk3ecj5f.db.yandex.net'
