package main

import (
	"a.yandex-team.ru/travel/library/go/resourcestorage"
)

type Config struct {
	DictType     string `config:"dict-type"`
	SandboxToken string `config:"sandbox-token,required"`

	S3DictsPrefix string `config:"s3-dict-prefix"`
	S3AccessKey   string `config:"s3-access-key,required"`
	S3Secret      string `config:"s3-secret,required"`
	S3Storage     resourcestorage.S3StorageConfig
}

var Cfg = Config{
	S3DictsPrefix: "dicts",
	S3Storage:     resourcestorage.DefaultS3StorageConfig,
}
