package main

import (
	"path"
)

type DictLocationBuilder interface {
	GetResourceName() string
	GetS3ResourceName() string
}

type RaspDictLocationBuilder struct {
	s3DictsPrefix string
	resourceName  string
}

func (builder *RaspDictLocationBuilder) GetResourceName() string {
	return "TRAVEL_DICT_RASP_" + builder.resourceName + "_PROD"
}

func (builder *RaspDictLocationBuilder) GetS3ResourceName() string {
	return path.Join(builder.s3DictsPrefix, builder.resourceName)
}

type DictLocationBuilders map[string]DictLocationBuilder

func (builders DictLocationBuilders) AddRasp(resourceName string, s3DictsPrefix string) {
	builders[resourceName] = &RaspDictLocationBuilder{
		s3DictsPrefix: s3DictsPrefix,
		resourceName:  resourceName,
	}
}
