package main

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type (
	ProviderFunc    func() proto.Message
	MessageProvider struct {
		messageProvider ProviderFunc
	}
)

func (p *MessageProvider) Load(raw []byte) (proto.Message, error) {
	errWrapper := xerrors.NewSentinel("MessageProvider.Load")

	message := p.messageProvider()
	if err := proto.Unmarshal(raw, message); err != nil {
		return nil, errWrapper.Wrap(err)
	}
	return message, nil
}

type MessageProviders map[string]MessageProvider

func (builders MessageProviders) AddProvider(key string, p ProviderFunc) {
	builders[key] = MessageProvider{
		messageProvider: p,
	}
}
