#!/bin/sh

set -o errexit
set -o nounset

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"

export JAVA_HOME PATH

PROJECT_ROOT=`pwd .`
CONDUCTOR_AUTH=`cat ${PROJECT_ROOT}/.conductor_auth`
EMAIL=teamcity@yandex-team.ru
DEBUILD_CMD="dpkg-buildpackage -rfakeroot -sa -e${EMAIL} -I"
DEBCLEAN_CMD="debclean"
REPO_NAME="yandex-vertis-common"
DEBRELEASE_CMD="debrelease --to ${REPO_NAME} --nomail"
DEBTICKET_CMD="debticket -n --auth=$CONDUCTOR_AUTH"

if [ -n "$1" ]; then
    PROJECT_DIR="${PROJECT_ROOT}/$1/"
else
    echo 'Not enough command line arguments - project name not specified'
    exit 1
fi

if [ ! -e "${PROJECT_DIR}/debian/changelog" ]; then
    echo 'debian/changelog not found'
    exit 2
fi


#Build phase
echo "Build debian package..." 
cd $PROJECT_DIR && $DEBUILD_CMD || exit 3

echo "Debian clean..."
cd $PROJECT_DIR && $DEBCLEAN_CMD || exit 4


#Deploy phase
DEB_SOURCE=$(dpkg-parsechangelog | sed -n 's/^Source: //p')
DEB_VERSION=$(dpkg-parsechangelog | sed -n 's/^Version: //p')
DEB_ARCH=$(dpkg-architecture | grep DEB_BUILD_ARCH= | sed -e 's/.*=//')
CHANGES_FILE="${DEB_SOURCE}_${DEB_VERSION}_${DEB_ARCH}.changes"


PACKAGE_ID=${DEB_SOURCE}-${DEB_VERSION}

echo "Deploy package..."
echo "Checking dist.yandex.ru ${CHANGES_FILE}"
if ssh dist.yandex.ru "check4changes '${REPO_NAME}' '${CHANGES_FILE}'"; then
    echo "Package ${PACKAGE_ID} is already in ${REPO_NAME} repo. Conductor ticket will not be created."
    exit 0
else
    echo "Release package to ${REPO_NAME}..." 
    cd $PROJECT_DIR && $DEBRELEASE_CMD || exit 5

    echo "Ticket in conductor is NOT created: please either create it manually or use sandbox to deploy porto image"
    #cd $PROJECT_DIR && $DEBTICKET_CMD || exit 6

    echo "Marking source code with bookmark ${PACKAGE_ID}..."

    set +e
    cd $PROJECT_ROOT && hg bookmark "${PACKAGE_ID}" || exit 6
	cd $PROJECT_ROOT && hg push -B "${PACKAGE_ID}"
	if [ $? -ne 1 ]; then
		exit 7
	fi
	set -e

	echo "##teamcity[buildNumber '${DEB_VERSION}_{build.number}']"

fi
