package ru.yandex.travel.yt.migrator.Mappings;


import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;

import ru.yandex.travel.yt.mappings.YtColumn;
import ru.yandex.travel.yt.mappings.YtTable;

@YtTable(tableName = "avatars")
@Table(keyspace = "tours", name="avatars")
public class Avatar {
    @YtColumn
    @PartitionKey
    @Column(name = "u")
    private String Url;

    @YtColumn
    @Column(name = "g")
    private int Group;

    @YtColumn
    @Column(name = "p")
    private int Provider;

    @YtColumn
    @Column(name = "h")
    private String Host;

    @YtColumn
    @Column(name = "n")
    private String Name;

    @YtColumn
    @Column(name = "x")
    private int Width;

    @YtColumn
    @Column(name = "y")
    private int Height;

    @YtColumn
    @Column(name = "ph")
    private String phash;

    @YtColumn
    @Column(name = "nf")
    private String NNF;

    public Avatar(String url, int group, int provider, String host, String name, int width, int height, String phash, String NNF) {
        Url = url;
        Group = group;
        Provider = provider;
        Host = host;
        Name = name;
        Width = width;
        Height = height;
        this.phash = phash;
        this.NNF = NNF;
    }

    public Avatar() {
    }

    public String getUrl() {
        return Url;
    }

    public int getGroup() {
        return Group;
    }

    public int getProvider() {
        return Provider;
    }

    public String getHost() {
        return Host;
    }

    public String getName() {
        return Name;
    }

    public int getWidth() {
        return Width;
    }

    public int getHeight() {
        return Height;
    }

    public String getPhash() {
        return phash;
    }

    public String getNNF() {
        return NNF;
    }

    public void setUrl(String url) {
        Url = url;
    }

    public void setGroup(int group) {
        Group = group;
    }

    public void setProvider(int provider) {
        Provider = provider;
    }

    public void setHost(String host) {
        Host = host;
    }

    public void setName(String name) {
        Name = name;
    }

    public void setWidth(int width) {
        Width = width;
    }

    public void setHeight(int height) {
        Height = height;
    }

    public void setPhash(String phash) {
        this.phash = phash;
    }

    public void setNNF(String NNF) {
        this.NNF = NNF;
    }
}
