package ru.yandex.travel.yt.migrator.Mappings;

import java.nio.ByteBuffer;

import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.datastax.driver.mapping.annotations.Transient;

import ru.yandex.travel.yt.mappings.YtColumn;
import ru.yandex.travel.yt.mappings.YtTable;
import ru.yandex.travel.yt.migrator.Convertible;

@YtTable(tableName = "notifications")
@Table(keyspace = "tours", name = "notifications")
public class Notification implements Convertible {
    @YtColumn
    @PartitionKey
    @Column(name = "u")
    private String user;

    @YtColumn
    @PartitionKey(1)
    @Column(name = "s")
    private String subscriptionId;

    @Column(name = "n")
    private ByteBuffer n;

    @YtColumn
    @Transient
    private byte[] notification;

    public Notification() {
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getSubscriptionId() {
        return subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public ByteBuffer getN() {
        return n;
    }

    public void setN(ByteBuffer n) {
        this.n = n;
    }

    public byte[] getNotification() {
        return notification;
    }

    public void setNotification(byte[] notification) {
        this.notification = notification;
    }

    @Override
    public void convert() {
        notification = Bytes.getArray(n);
    }
}
