package ru.yandex.travel.yt.migrator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.annotations.Table;

import ru.yandex.travel.yt.Factory;
import ru.yandex.travel.yt.YtDao;

public class TwoWayMapper<T> {
    private Mapper<T> mapper;
    private YtDao<T> ytDao;
    private Class<T> klass;
    private String query;
    private MappingManager manager;

    public TwoWayMapper(MappingManager manager, Factory ytFactory, Class<T> klass, String clusterName, String basePath) {
        this.klass = klass;
        this.manager = manager;
        this.mapper = manager.mapper(klass);
        this.ytDao = new YtDao<T>(ytFactory, clusterName, basePath, klass);
        Table ann = klass.getAnnotation(Table.class);
        query = String.format("SELECT * from %s.%s", ann.keyspace(), ann.name());
    }

    public void run(int batchSize) {
        long total = 0;
        Iterator<T> it = getAll();
        List<T> batch = new ArrayList<>(batchSize);
        while (it.hasNext()) {
            T obj = it.next();
            if (obj instanceof Convertible) {
                ((Convertible) obj).convert();
            }
            batch.add(obj);
            if (batch.size() == batchSize || !it.hasNext()) {
                System.out.println("Putting " + batch.size() + " items of type " + klass.getSimpleName() + " to YT");
                ytDao.put(batch).join();
                total += batch.size();
                System.out.println(total + " items done");
                batch.clear();
            }
        }
    }

    private Iterator<T> getAll() {
        ResultSet execute = manager.getSession().execute(query);
        return mapper.map(execute).iterator();
    }
}
