package ru.yandex.travel.yt.migrator;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.datastax.driver.mapping.MappingManager;
import org.kohsuke.args4j.CmdLineParser;

import ru.yandex.travel.yt.Factory;
import ru.yandex.travel.yt.migrator.Mappings.Avatar;
import ru.yandex.travel.yt.migrator.Mappings.Notification;


class Main {
    public static void main(String[] args) throws Exception {
        Cfg cfg = new Cfg();
        CmdLineParser cmdArgs = new CmdLineParser(cfg);
        cmdArgs.parseArgument(args);
        Map<String, Map<String, List<String>>> clusterMap = new HashMap<>();

        Map<String, List<String>> freud = new HashMap<>();
        freud.put("default", Arrays.asList(
                "n0007i.freud.yt.yandex.net",
                "n0008i.freud.yt.yandex.net",
                "n0009i.freud.yt.yandex.net"));
        Map<String, List<String>> pythia = new HashMap<>();
        pythia.put("default", Arrays.asList(
                "n0001-sas.pythia.yt.yandex.net",
                "n0002-sas.pythia.yt.yandex.net",
                "n0003-sas.pythia.yt.yandex.net"));
        Map<String, List<String>> zeno = new HashMap<>();
        zeno.put("default", Arrays.asList(
                "n0001i.zeno.yt.yandex.net",
                "n0002i.zeno.yt.yandex.net",
                "n0003i.zeno.yt.yandex.net"
        ));
        Map<String, List<String>> markov = new HashMap<>();
        markov.put("man", Collections.singletonList("m01-man.markov.yt.yandex.net"));
        markov.put("sas", Collections.singletonList("m02-sas.markov.yt.yandex.net"));
        markov.put("myt", Collections.singletonList("m03-myt.markov.yt.yandex.net"));
        Map<String, List<String>> senecaMan = new HashMap<>();
        senecaMan.put("man", Arrays.asList(
                "n0001i.seneca-man.yt.yandex.net",
                "n0002i.seneca-man.yt.yandex.net",
                "n0003i.seneca-man.yt.yandex.net"
        ));
        Map<String, List<String>> senecaSas = new HashMap<>();
        senecaSas.put("sas", Arrays.asList(
                "n0035h.seneca-sas.yt.yandex.net",
                "n0036h.seneca-sas.yt.yandex.net",
                "n0037h.seneca-sas.yt.yandex.net"
        ));
        Map<String, List<String>> senecaMyt = new HashMap<>();
        senecaMyt.put("myt", Arrays.asList(
                "n0035-myt.seneca-myt.yt.yandex.net",
                "n0036-myt.seneca-myt.yt.yandex.net",
                "n0037-myt.seneca-myt.yt.yandex.net"
        ));
        clusterMap.put("freud", freud);
        clusterMap.put("pythia", pythia);
        clusterMap.put("zeno", zeno);
        clusterMap.put("markov", markov);
        clusterMap.put("seneca-man", senecaMan);
        clusterMap.put("seneca-sas", senecaSas);
        clusterMap.put("seneca-myt", senecaMyt);

        Factory ytFactory = new Factory(clusterMap, 9013, cfg.getYtLogin(), cfg.getYtToken(), "my");
        ytFactory.setClientTimeout(Duration.ofSeconds(10));
        ytFactory.setLocalTimeout(Duration.ofSeconds(3));
        ytFactory.setClientTimeout(Duration.ofSeconds(5));
        ytFactory.setPingTimeout(Duration.ofSeconds(20));

        System.out.println("YT factory initialized");
        Cluster cluster = Cluster.builder()
                .addContactPoint(cfg.getCHost())
                .withCredentials(cfg.getCLogin(), cfg.getCPassword())
                .withQueryOptions(new QueryOptions().setFetchSize(10000))
                .withSocketOptions(new SocketOptions().setReadTimeoutMillis(3000000).setConnectTimeoutMillis(30000))
//                .withLoadBalancingPolicy(new WhiteListPolicy(Policies.defaultLoadBalancingPolicy(), Collections.singletonList(new InetSocketAddress("localhost", 9042))))
                .build();

        Session session = cluster.connect(cfg.getCKeyspace());
        System.out.println("C* session initialized");
        MappingManager mngr = new MappingManager(session);
        Map<String, TwoWayMapper<?>> mappers = new HashMap<>();
        mappers.put("avatars",  new TwoWayMapper<Avatar>(mngr, ytFactory, Avatar.class, cfg.getYtCluster(),
                cfg.getYtPath()));
        mappers.put("notifications", new TwoWayMapper<>(mngr, ytFactory, Notification.class, cfg.getYtCluster(),
                cfg.getYtPath()));

        if (mappers.containsKey(cfg.getMapper())) {
            System.out.println("Running migrations for " + cfg.getMapper());
            mappers.get(cfg.getMapper()).run(10000);
        }

        System.out.println("All done");

        ytFactory.close();
    }
}
