package ru.yandex.travel.yt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplicationInfo {
    private Boolean isReplicated;
    private boolean allowsSyncronousReads;
    private List<String> readClusterNames = new ArrayList<>();
    private Map<String, String> replicaMap = new HashMap<>();
    private Map<String, Long> replicaLagTimes = new HashMap<>();

    public ReplicationInfo(boolean allowsSyncronousReads,
                            List<String> readClusterNames, Map<String, String> replicaMap,
                            Map<String, Long> replicaLagTimes) {
        this.isReplicated = true;
        this.allowsSyncronousReads = allowsSyncronousReads;
        this.readClusterNames = new ArrayList<>(readClusterNames);
        this.replicaMap = new HashMap<>(replicaMap);
        this.replicaLagTimes = new HashMap<>(replicaLagTimes);
    }

    public ReplicationInfo() {
        this.isReplicated = false;
        this.allowsSyncronousReads = true;
    }


    public Boolean getReplicated() {
        return isReplicated;
    }

    public boolean isAllowsSyncronousReads() {
        return allowsSyncronousReads;
    }

    public List<String> getReadClusterNames() {
        return readClusterNames;
    }

    public Map<String, Long> getReplicaLagTimes() {
        return replicaLagTimes;
    }

    public Map<String, String> getReplicaMap() {
        return replicaMap;
    }
}
