package ru.yandex.travel.yt;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.yt.queries.QueryPart;


public interface YtDao<T> {
    CompletableFuture<List<T>> select(List<QueryPart> queryParts);

    CompletableFuture<List<T>> select(QueryPart... queryParts);

    CompletableFuture<Optional<T>> get(List<Object> keyValues);

    CompletableFuture<Optional<T>> get(Object... keyValues);

    CompletableFuture<Void> put(T object);

    CompletableFuture<Void> put(List<T> objects);

    CompletableFuture<Void> delete(List<Object> keyValues);

    CompletableFuture<Void> delete(Object... keyValues);

    String getTableName();

    Class<?> getMappedClass();

    String getClusterName();
}
