package ru.yandex.travel.yt.benchmark;

import java.util.Optional;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.travel.yt.Factory;
import ru.yandex.travel.yt.YtDao;
import ru.yandex.travel.yt.daos.MirroredYtDao;
import ru.yandex.travel.yt.daos.SingleYtDao;

public class Benchmark {
    private static Logger logger = LoggerFactory.getLogger("Main");
    public static void main(String[] args) throws InterruptedException {
        Factory f = new Factory(9013, "tivelkov", args[0], "my");
        String basePath = "//home/travel/tivelkov";
        YtDao<TestEntity> hahnDao = new SingleYtDao<TestEntity>(f, "hahn", basePath, TestEntity.class);
        YtDao<TestEntity> freudDao = new SingleYtDao<TestEntity>(f, "freud", basePath, TestEntity.class);
        YtDao<TestEntity> banachDao = new SingleYtDao<TestEntity>(f, "banach", basePath, TestEntity.class);
        YtDao<TestEntity> zenoDao = new SingleYtDao<TestEntity>(f, "zeno", basePath, TestEntity.class);
        MirroredYtDao<TestEntity> hahnBanach = new MirroredYtDao<TestEntity>(hahnDao, banachDao);
        MirroredYtDao<TestEntity> banachHahn = new MirroredYtDao<TestEntity>(banachDao, hahnDao);
        MirroredYtDao<TestEntity> freudZeno = new MirroredYtDao<TestEntity>(freudDao, zenoDao);
        MirroredYtDao<TestEntity> zenoFreud = new MirroredYtDao<TestEntity>(zenoDao, freudDao);
//        testReadLatency(hahnBanach, banachHahn, 5000);
        testReadLatency(freudZeno, zenoFreud, 5000);



        System.out.println("Closing factory");
        f.close();
        System.out.println("Bye!");
    }



    public static void testReadLatency(YtDao<TestEntity> writeDao, YtDao<TestEntity> readDao,  int num) {
        long min_read = Long.MAX_VALUE;
        long max_read = 0;
        long sum_read = 0;
        long min_write = Long.MAX_VALUE;
        long max_write = 0;
        long sum_write = 0;
        for (int i = 0; i < num; i++) {
            String value = UUID.randomUUID().toString();
            TestEntity te = new TestEntity(i, value.getBytes());
            long started = System.currentTimeMillis();
            Throwable err = writeDao.put(te).handle((v, t) -> t).join();
            if (err != null) {
               logger.error("Write failed");
                err.printStackTrace();
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            long done = System.currentTimeMillis() - started;

            if (done < min_write) {
                min_write = done;
            }
            if (done > max_write) {
                max_write = done;
            }
            sum_write += done;

            int numAttempts = 0;
            Optional<TestEntity> e = Optional.empty();
            started = System.currentTimeMillis();
            while (!e.isPresent()) {
                try {
                    e = readDao.get(i, value).join();
                }
                catch (Exception ex) {
                   logger.error("Read failed: " + ex.getMessage(), ex);
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
//                    throw ex;
                }
                numAttempts += 1;
                if (numAttempts >=100) {
                    logger.warn("Could not read in 100 attempts");
                    break;
                }
            }

            done = System.currentTimeMillis() - started;
           logger.info(readDao.getClusterName() + ": done in " + done + "ms in " + numAttempts + " attempts");
            if (done < min_read) {
                min_read = done;
            }
            if (done > max_read) {
                max_read = done;
            }
            sum_read += done;
            try {
                writeDao.delete(i, value).join();
            }
            catch (Exception ex) {
                System.out.println("Delete failed");
            }

        }
        System.out.println("Average read time " + sum_read / (double) num);
        System.out.println("Max read time " + max_read);
        System.out.println("Min read time " + min_read);
        System.out.println("Average write time " + sum_write / (double) num);
        System.out.println("Max write time " + max_write);
        System.out.println("Min write time " + min_write);
    }
}
