package ru.yandex.travel.yt.queries;

public class Compare<T> extends QueryPart {
    private T value;
    private String sign;

    Compare(String name, T value, String sign) {
        super(name);
        this.value = value;
        this.sign = sign;
    }

    @Override
    public String getQuery() {
        return  "[" + name  + "] " + sign + " " + quoteValue(value);
    }

    public static <T> Compare<T> eq(String name, T value) {
        return new Compare<>(name, value, "=");
    }

    public static <T> Compare<T> ne(String name, T value) {
        return new Compare<>(name, value, "!=");
    }

    public static <T> Compare<T> ge(String name, T value) {
        return new Compare<>(name, value, ">=");
    }

    public static <T> Compare<T> le(String name, T value) {
        return new Compare<>(name, value, "<=");
    }

    public static <T> Compare<T> gt(String name, T value) {
        return new Compare<>(name, value, ">");
    }

    public static <T> Compare<T> lt(String name, T value) {
        return new Compare<>(name, value, "<");
    }

}
