package ru.yandex.travel.yt.queries;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class In<T> extends QueryPart {
    private Collection<T> values;

    public In(String name, Collection<T> values) {
        super(name);
        this.values = values;
    }

    @Override
    public String getQuery() {
        List<String> surrounded = values.stream().map(this::quoteValue).collect(Collectors.toList());
        return name + " IN (" + String.join(",", surrounded) +")";
    }
}
