package ru.yandex.travel.yt.switching;

import org.slf4j.Logger;

public class ErrorFlag {
    private final Object syncRoot = new Object();

    private volatile boolean internalError = false;
    private volatile int numSuccesses;

    private int successesInRow;
    private String name;
    private Logger logger;

    public ErrorFlag(String name, Logger logger) {
        this(name, 10, logger);
    }

    public ErrorFlag(String name, int successesInRow, Logger logger) {
        this.successesInRow = successesInRow;
        this.numSuccesses = successesInRow;
        this.name = name;
        this.logger = logger;
    }

    public void ok() {
        if (internalError) {
            synchronized (syncRoot) {
                if (internalError) {
                    if (numSuccesses < successesInRow) numSuccesses++;
                    if (numSuccesses == successesInRow) {
                        internalError = false;
                        logger.info("Error flag for {} is now cleared", name);

                    }
                }
            }
        }
    }

    public void error() {
        synchronized (syncRoot) {
            if (!internalError) {
                logger.warn("Error flag for {} is now active", name);
            }
            internalError = true;
            numSuccesses = 0;
        }
    }

    public boolean check() {
        return internalError;
    }
}
