#!/bin/bash -e

# CONNECTION_PARAMETERS
BASE_PATH="//home/travel/testing1"
MASTER="seneca-myt"
#SLAVES="zeno freud"
#MASTER="markov"
#SLAVES="seneca-man seneca-sas seneca-myt"

# TABLE_SCHEMAS
HOTELS_SCHEMA="{name=SessionId;type=string;sort_order=ascending};\
{name=Id;type=string;sort_order=ascending};\
{name=Timestamp;type=uint64};\
{name=Value;type=string}"

TOURS_SCHEMA="{name=SessionId;type=string;sort_order=ascending};\
{name=Id;type=string;sort_order=ascending};\
{name=Timestamp;type=uint64};\
{name=Value;type=string}"

MIN_PRICE_SCHEMA="{name=From;type=int64;sort_order=ascending};\
{name=To;type=int64;sort_order=ascending};\
{name=Nights;type=int64;sort_order=ascending};\
{name=Ages;type=string;sort_order=ascending};\
{name=When;type=uint64;sort_order=ascending};\
{name=Operator;type=int64;sort_order=ascending};\
{name=Timestamp;type=uint64};\
{name=MinPrice;type=int64}"

DIRECTION_PRICE_SCHEMA="{name=From;type=int64;sort_order=ascending};\
{name=Ages;type=string;sort_order=ascending};\
{name=Month;type=int64;sort_order=ascending};\
{name=GeoId;type=int64;sort_order=ascending};\
{name=BestPrice;type=string};\
{name=WriteTime;type=uint64}"

FLIGHS_SCHEMA="{name=SessionId;type=string;sort_order=ascending};\
{name=Flights;type=string};\
{name=Timestamp;type=uint64}"

TRANSFERS_SCHEMA="{name=SessionId;type=string;sort_order=ascending};\
{name=Transfers;type=string};\
{name=Timestamp;type=uint64};"

AVATARS_SCHEMA="{name=Url;type=string;sort_order=ascending};\
{name=Group;type=int64};\
{name=Provider;type=int64};\
{name=Host;type=string};\
{name=Name;type=string};\
{name=Width;type=int64};\
{name=Height;type=int64};\
{name=pHash;type=string};\
{name=NNF;type=string}"

NOTIFICATIONS_SCHEMA="
{name=user;type=string;sort_order=ascending};\
{name=subscriptionId;type=string;sort_order=ascending};\
{name=notification;type=string}"


# TTLS
TTL_20_MINS=1200000
TTL_24_HOURS=86400000
TTL_5_MIN=300000
TTL_90_days=7776000000
MEM="uncompressed"
NOMEM="none"
BUNDLE="travel"
source ./yt_functions.sh

#drop_table hotels FORCE
#drop_table tours FORCE
#drop_table hotels_long_cache FORCE
#drop_table tours_long_cache FORCE
#drop_table min_price FORCE
#drop_table hotels_min_price FORCE
#drop_table direction_price FORCE
#drop_table hotels_direction_price FORCE
#drop_table flights FORCE
#drop_table transfers FORCE
#drop_table avatars FORCE
#drop_table notifications FORCE
#
create_simple_table hotels $HOTELS_SCHEMA $TTL_20_MINS $MEM $BUNDLE
create_simple_table hotels_long_cache $HOTELS_SCHEMA $TTL_24_HOURS $MEM $BUNDLE
create_simple_table tours $TOURS_SCHEMA $TTL_20_MINS $MEM $BUNDLE
create_simple_table tours_long_cache $TOURS_SCHEMA $TTL_24_HOURS $MEM $BUNDLE
create_simple_table min_price $MIN_PRICE_SCHEMA $TTL_24_HOURS $MEM $BUNDLE
create_simple_table hotels_min_price $MIN_PRICE_SCHEMA $TTL_24_HOURS $MEM $BUNDLE
create_simple_table direction_price $DIRECTION_PRICE_SCHEMA $TTL_24_HOURS $MEM $BUNDLE
create_simple_table hotels_direction_price $DIRECTION_PRICE_SCHEMA $TTL_24_HOURS $MEM $BUNDLE
create_simple_table flights $FLIGHS_SCHEMA $TTL_5_MIN $MEM $BUNDLE
create_simple_table transfers $TRANSFERS_SCHEMA $TTL_20_MINS $MEM $BUNDLE
create_simple_table avatars $AVATARS_SCHEMA 0 $NOMEM $BUNDLE
create_simple_table notifications $NOTIFICATIONS_SCHEMA $TTL_90_days $NOMEM $BUNDLE
