#!/bin/bash -e

create_dir () {
  yt --proxy $1 get $2 1>/dev/null 2>&1 || yt --proxy $1 create map_node $2
}

create_simple_table () {
    TABLE_PATH=$BASE_PATH/$1
    SCHEMA=$2
    TTL=$3
    IN_MEMORY_MODE=$4
    BUNDLE=$5
    # Создаем директорию
    BASE_PATH=$(dirname $TABLE_PATH)
    TTL_STR=""
        if [[ "$TTL" > 0 ]];
        then
            TTL_STR=";min_data_versions=0;max_data_versions=1;min_data_ttl=0;max_data_ttl=$TTL"
        fi
    create_dir $MASTER $BASE_PATH
     yt --proxy $MASTER create table $TABLE_PATH --attr '{
      dynamic=%true;in_memory_mode='$IN_MEMORY_MODE';enable_lookup_hash_tables=%true
      '$TTL_STR';
      schema=['$SCHEMA']}'
     if [[ "$BUNDLE" != "default" ]];
     then
            yt --proxy $MASTER set $TABLE_PATH/@tablet_cell_bundle $BUNDLE
     fi
      echo "Mount master"
    yt --proxy $MASTER mount-table $TABLE_PATH
}

create_repl_table () {
    TABLE_PATH=$BASE_PATH/$1
    SCHEMA=$2
    TTL=$3
    IN_MEMORY_MODE=$4
    BUNDLE=$5
    # Создаем директорию
    BASE_PATH=$(dirname $TABLE_PATH)

    create_dir $MASTER $BASE_PATH

    echo "Create master table $TABLE_PATH at $MASTER"
    yt --proxy $MASTER create replicated_table $TABLE_PATH --attr '{
      dynamic=%true;
      schema=['$SCHEMA']}'

    for SLAVE in $(echo $SLAVES); do
        create_dir $SLAVE $BASE_PATH
        echo "Assign replicas at $SLAVE"
        REPLICA_ID=$(yt --proxy $MASTER create table_replica --attr '{
          table_path="'$TABLE_PATH'";
          replica_path="'$TABLE_PATH'";
          cluster_name='$SLAVE'
        }')
        echo "Create $TABLE_PATH replica at $SLAVE, id $REPLICA_ID"
        TTL_STR=""
        if [[ "$TTL" > 0 ]];
        then
            TTL_STR=";min_data_versions=0;max_data_versions=1;min_data_ttl=0;max_data_ttl=$TTL"
        fi
        yt --proxy $SLAVE create table $TABLE_PATH --attr '{
          upstream_replica_id="'$REPLICA_ID'";
          dynamic=%true;in_memory_mode='$IN_MEMORY_MODE';enable_lookup_hash_tables=%true
          '$TTL_STR';
          schema=['$SCHEMA']}'
        if [[ "$BUNDLE" != "default" ]];
        then
            yt --proxy $SLAVE set $TABLE_PATH/@tablet_cell_bundle $BUNDLE
        fi
        echo "Enable replica"
        yt --proxy $MASTER alter-table-replica $REPLICA_ID --enable
        echo "Mount replica"
        yt --proxy $SLAVE mount-table $TABLE_PATH
    done

    echo "Mount master"
    yt --proxy $MASTER mount-table $TABLE_PATH
}

drop_table () {
    TABLE_PATH=$BASE_PATH/$1
    if [[ "$2" != "FORCE" ]];
    then
        echo "Will REMOVE $TABLE_PATH at $MASTER and slaves? (YES?)"
        read ANS
        if [[ "$ANS" != "YES" ]];
        then
          echo "Best choice"
          exit 1
        fi
    fi

    # смотрим идентификаторы реплик
    LOCAL_SLAVES=$(yt --proxy $MASTER get $TABLE_PATH/@replicas | grep cluster_name | cut -d '"' -f 4)

    for SLAVE in $(echo $LOCAL_SLAVES); do
      echo "Remove $TABLE_PATH at $SLAVE"
      yt --proxy $SLAVE remove $TABLE_PATH || true
    done

    echo "Remove $TABLE_PATH at $MASTER"
    yt --proxy $MASTER remove $TABLE_PATH
}
