import sbt.Keys._
import sbt.Tests.{Group, SubProcess}
import sbt._
import scoverage.ScoverageKeys._

object TestSettings {

  lazy val settings = Seq(
    testOptions in Test ++= Seq(
      Tests.Argument(TestFrameworks.ScalaTest, "-oD"),
      Tests.Argument(TestFrameworks.ScalaTest, "-C", "ru.yandex.tours.testkit.AllureReporter")
    ),

    logBuffered in Test := true,

    fork in Test := true,
    testForkedParallel in project := true,

    //from https://github.com/nchammas/spark/commit/5f7683b5b81e32e7265a944c1e867e252023d7b8
    testGrouping in Test := {
      val original: Seq[Tests.Group] = (testGrouping in Test).value

      original.map { group =>
        val forkOptions = ForkOptions(
          bootJars = Nil,
          javaHome = javaHome.value,
          connectInput = connectInput.value,
          runJVMOptions = (javaOptions in Test).value,
          workingDirectory = Some(new File(System.getProperty("user.dir"))),
          envVars = envVars.value
        )

        group.copy(runPolicy = Tests.SubProcess(forkOptions))
      }
    },

    coverageExcludedPackages := "<empty>;Reverse.*;ru.yandex.tours.tools.*;controllers.ref.*;views.*",
    coverageExcludedFiles := ".*\\.template\\.scala;.*Tool\\.scala",
    commands     += TestSettings.slowMode
  ) ++ ItSettings.settings

  val slowMode = Command.command("slow-mode") { state =>
    val extracted = Project.extract(state)
    println("Enabled slow-mode")
    extracted.append(extracted.currentProject.aggregate.flatMap { project => Seq(
      fork in (project, Test) := true,
      parallelExecution in Global := false,
      parallelExecution in (project, update) := true,
      parallelExecution in (project, Test) := true,
      parallelExecution in (project, Compile) := true,
      testForkedParallel in project := false
    )}, state)
  }
}

object ItSettings {

  val IntTest = config("it") extend Test

  def itFilter(name: String): Boolean = name matches ".*I(nt)?(Spec|Test)$"
  def unitFilter(name: String): Boolean = ((name endsWith "Test") || (name endsWith "Spec")) && !itFilter(name)

  lazy val settings = inConfig(IntTest)(Defaults.testTasks) ++ Seq(
    testOptions in Test += Tests.Filter(unitFilter),
    testOptions in IntTest := Seq(Tests.Filter(itFilter)),

    testGrouping in IntTest := (testGrouping in Test).value
  )
}