#!/usr/bin/env bash

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
export PATH

export MAVEN_OPTS="-Xmx2g -XX:MaxPermSize=512M -XX:ReservedCodeCacheSize=512m"
HADOOP_VERSION=2.6.0-cdh5.4.7
RELEASE_REPO=yandex_vertis_releases::default::http://artifactory.yandex.net/artifactory/yandex_vertis_releases
SNAPSHOT_REPO=yandex_vertis_snapshots::default::http://artifactory.yandex.net/artifactory/yandex_vertis_snapshots
URL=http://www.eu.apache.org/dist/spark/spark-1.6.0/spark-1.6.0.tgz
DIR=spark-1.6.0

rm -rf "${DIR}"

wget "${URL}"
tar -xf "${DIR}.tgz"
rm -rf "${DIR}.tgz"
cd "${DIR}"

./dev/change-scala-version.sh 2.11

build/mvn -Pyarn \
          -Phadoop-2.6 -Dhadoop.version=${HADOOP_VERSION} \
          -Phadoop-provided \
          -Phive -Phive-thriftserver \
          -Dscala-2.11 \
          -DskipTests -Dmaven.test.skip=true \
          -DdeployAtEnd=true \
          -DaltReleaseDeploymentRepository=${RELEASE_REPO} \
          -DaltSnapshotDeploymentRepository=${SNAPSHOT_REPO} \
          clean package deploy

build/zinc-0.3.5.3/bin/zinc -shutdown

cd ..
rm -rf "${DIR}"