#!/bin/bash
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

secret=$(grep 'tours.partners.secret' /etc/yandex/vertis-datasources/datasources.properties | awk -F '=' '{gsub(/ /, "", $2);print $2}')
IFS=':' read key iv <<< "$secret"
if [ -z "$key" ] || [ -z "$iv" ]
then
echo "Key or iv are not defined"
exit 1
fi
cat $DIR/../tours-core/src/main/resources/partners-decrypted.conf |
gawk '
{
  if ($0 ~ "Authorization" || $0 ~ "ApiKey") {
      start=index($0, "\"")+1
      end=index(substr($0, start), "\"")-1
      token=substr($0, start, end);
      command="openssl aes-128-cbc -K '$key' -iv '$iv' -a -A";
      print token |& command
      close(command, "to")
      command |& getline res
      close(command)
      print substr($0, 0, start-1) res "\""
  }
  else {
      print $0
  }
}' > $DIR/../tours-core/src/main/resources/partners.conf
rm $DIR/../tours-core/src/main/resources/partners-decrypted.conf