package ru.yandex.tours.db

import play.api.libs.json.Json
import ru.yandex.tours.geo.base.custom.{PartialRegion, CustomRegion}
import ru.yandex.tours.geo.base.region.Types
import ru.yandex.tours.util.parsing.IntValue
import slick.driver.MySQLDriver.api._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 23.11.15
 */
class CustomRegions(tag: Tag) extends Table[CustomRegion](tag, "custom_regions") {
  def id = column[Int]("id", O.PrimaryKey, O.AutoInc)
  def isNew = column[Boolean]("is_new")
  def isMeta = column[Boolean]("is_meta")
  def partialRegion = column[String]("partial_region")
  def children = column[String]("children")

  def * = (id, isNew, isMeta, partialRegion, children).shaped <> ({
    case (id, isNew, _, partialRegion, children) =>
      val region = Json.parse(partialRegion).as[PartialRegion]
      CustomRegion(id, isNew, region, children.split(",").flatMap(IntValue.apply))
  }, {
    r: CustomRegion =>
      val regionJson = Json.toJson(r.partialRegion).toString()
      Some((r.id, r.isNew, r.isMeta, regionJson, r.children.mkString(",")))
  })
}

object CustomRegions {
  val table = TableQuery[CustomRegions]
}