package ru.yandex.tours.db

import play.api.libs.json.{Format, Json}
import slick.ast.BaseTypedType
import slick.driver.MySQLDriver.api._
import slick.jdbc.JdbcType

import scala.reflect.ClassTag

/**
  * Created by Evgeny Zhoga on 02.02.16.
  */
object DBUtils {
  def jsBasedColumnType[T: ClassTag](implicit format: Format[T]): JdbcType[T] with BaseTypedType[T] =
    MappedColumnType.base[T, String](
      jsonable => { Json.toJson(jsonable).toString() },
      str => { Json.parse(str).validate.getOrElse(null.asInstanceOf[T]) }
    )

}
