package ru.yandex.tours.db

import ru.yandex.tours.db.ExternalHotelInfo.ExternalInfo
import ru.yandex.tours.util.GZip
import slick.driver.MySQLDriver.api._

class ExternalHotelInfo(tag: Tag) extends Table[ExternalInfo](tag, "external_hotel_info") {
  def id = column[Int]("id", O.PrimaryKey)

  def googleResponse = column[Array[Byte]]("google_response")

  override def * = (id, googleResponse).shaped <> ({
    case (id, googleResponse) =>
      val decoded = new String(GZip.decompress(googleResponse))
      ExternalInfo(id, decoded)
  }, {
    ei: ExternalInfo =>
      Some((ei.id, GZip.compress(ei.googlePlaceResponse.getBytes)))
  })

  def idForeignKey = foreignKey("external_info_hotel_fk",
                                id,
                                HotelStableIds.table)(_.id, ForeignKeyAction.Restrict, ForeignKeyAction.Restrict)
}

object ExternalHotelInfo {

  val table = TableQuery[ExternalHotelInfo]

  case class ExternalInfo(id: Int, googlePlaceResponse: String)
}
