package ru.yandex.tours.db

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner
import slick.driver.MySQLDriver.api._
import slick.lifted.{Index, MappedProjection, ProvenShape}

import scala.concurrent.Future


class HotelStableIds(tag: Tag) extends Table[HotelStableId](tag, HotelStableIds.TABLE_NAME) {
  def id: Rep[Int] = column[Int]("id", O.PrimaryKey, O.AutoInc)
  def partner: Rep[Int] = column[Int]("partner")
  def partnerObj: MappedProjection[Partner, Int] = partner <>(Partners.apply, p ⇒ Some(p.id))
  def partnerId: Rep[String] = column[String]("partner_id", O.SqlType("varchar(767)"))
  def idx: Index = index("partner_mapping_idx", (partner, partnerId), unique = true)

  override def * : ProvenShape[HotelStableId] = {
    (id, partner, partnerId).shaped <> ({
      case (id, partner, partnerId) ⇒
        HotelStableId(id, Partners(partner), partnerId)
    }, {
      hsi: HotelStableId ⇒
        Some(hsi.id, hsi.partner.id, hsi.partnerId)
    })
  }
}

object HotelStableIds {
  val table = TableQuery[HotelStableIds]
  private val TABLE_NAME = "hotel_stable_ids"

  def insertIgnore(db: DBWrapper)(partner: Int, partnerId: String): Future[Int] = {
    db.run(sqlu"insert ignore into #$TABLE_NAME (partner, partner_id) VALUES ($partner, $partnerId)")
  }
}

case class HotelStableId(id: Int, partner: Partner, partnerId: String)
