package ru.yandex.tours.db

import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner
import slick.driver.MySQLDriver.api._

/**
  * Created by asoboll on 09.02.16.
  */

case class MatchingResult(partner: Partner,
                          dataName: String,
                          matchedOk: Int,
                          matchedUncertain: Int,
                          added: Int,
                          deleted: Int,
                          transactionId: Int)

class MatchingStats(tag: Tag) extends Table[MatchingResult](tag, "matching_stats") {
  def partner = column[Int]("partner")
  def dataName = column[String]("data_name")
  def matchedOk = column[Int]("matched_ok")
  def matchedUncertain = column[Int]("matched_uncertain")
  def added = column[Int]("added_records")
  def deleted = column[Int]("deleted_records")
  def transactionId = column[Int]("transaction_id", O.PrimaryKey)

  def * = (partner, dataName, matchedOk, matchedUncertain, added, deleted, transactionId).shaped <> ({
    case (partner, dataName, matchedOk, hyps, added, deleted, transactionId) =>
      MatchingResult(Partners(partner), dataName, matchedOk, hyps, added, deleted, transactionId)
  }, {
    res: MatchingResult =>
      Some((res.partner.id, res.dataName, res.matchedOk, res.matchedUncertain, res.added, res.deleted, res.transactionId))
  })

  def transactionFK = foreignKey("transaction_fk", transactionId, Transactions.table)(_.id)
}

object MatchingStats {
  val table = TableQuery[MatchingStats]
}