package ru.yandex.tours.db

import ru.yandex.tours.app.Application
import slick.driver.MySQLDriver.api._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.11.15
 */
trait MySqlSupport {
  def db: DBWrapper
}

trait DefaultMySqlSupport extends MySqlSupport { app: Application =>

  lazy val db = new DBWrapper(
    Database.forConfig(
      "tours.mysql",
      app.config
    )
  )

  onStop {
    db.close()
  }

}
