package ru.yandex.tours.db

import play.api.libs.json.Json
import ru.yandex.tours.model.search.settings.SearchSettingsRecord
import ru.yandex.tours.model.search.{settings, SearchOptions, SearchType}
import ru.yandex.tours.serialize.json.CommonJsonFormats._
import slick.driver.MySQLDriver.api._

/**
  * Created by Evgeny Zhoga on 01.02.16.
  */
class SearchSettings(tag: Tag) extends Table[SearchSettingsRecord](tag, "search_settings") {
  import ru.yandex.tours.search.settings.RegionSearchSettings.Implicits._

  private implicit val parametersColumn = DBUtils.jsBasedColumnType[settings.Parameters]

  def regionId = column[Int]("region_id")
  def parameters = column[settings.Parameters]("parameters")

  def idx = index("idx_region_ids", regionId, unique = true)

  def * = (regionId, parameters).shaped <> (
      { case (regionId, parameters) => SearchSettingsRecord(regionId, parameters) },
      { r: SearchSettingsRecord => Some( (r.regionId, r.parameters) )}
    )
}

object SearchSettings {
  val table = TableQuery[SearchSettings]
}





